using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web;
using System.Diagnostics;
using Microsoft.Win32;

namespace Application_Monitor
{
    public partial class frmAbout : Form
    {
        public frmAbout()
        {
            InitializeComponent();
        }
        private void btnOK_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void frmAbout_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape)
            {
                this.Close();
            }
        }

        private void lnbWebSite_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
           // Process.Start(lnbWebSite.Text.Trim());
            string defaultBrowserPath = GetDefaultBrowserPath();
            try
            {
                // launch default browser
                Process.Start(defaultBrowserPath, lnbWebSite.Text.Trim());
            }
            catch (Exception exp)
            {
                string str = exp.Message;
            }
        }

        /// <summary>
        /// Reads path of default browser from registry
        /// </summary>
        /// <returns></returns>
        private static string GetDefaultBrowserPath()
        {
            string key = @"htmlfile\shell\open\command";
            RegistryKey registryKey =
            Registry.ClassesRoot.OpenSubKey(key, false);
            // get default browser path           
            return ((string)registryKey.GetValue(null, null)).Split('"')[1];
        }


    }
}